﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Security.Principal;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using MvcAuthorization;

namespace HIPS.Web.UI.Helpers
{
    public class AuthenticateThenAuthorizeOrThrowFilter : AuthorizeFilter
    {
        protected override bool AuthorizeCore(HttpContextBase httpContext)
        {
            if (httpContext.Handler != null)
            {
                return base.AuthorizeCore(httpContext);
            }

            // TODO: Support for resolving authentication of non MVC Handler, e.g. Cache retrieval
            return true;
        }

        protected override void HandleUnauthorizedRequest(AuthorizationContext filterContext)
        {
            IPrincipal user = filterContext.HttpContext.User;
            
            // Unauthenticated
            if (!user.Identity.IsAuthenticated)
            {
                filterContext.Result = new HttpUnauthorizedResult();
                return;
            }

            // Forbidden (insufficient access)
            filterContext.Result = new HttpStatusCodeResult(HttpStatusCode.Forbidden);
        }
    }
}
